#!/usr/bin/python3
"""Upotreba ./validate.py test/*.in*"""

import string


def check(lines):
    nl = []   # ispravno formatirane linije

    n = int(lines[0])
    nl.append('{}\n'.format(n))
    assert 3 <= n <= 10**5, "Neispravni n"

    a, b, c = map(int, lines[1].split())
    nl.append('{} {} {}\n'.format(a, b, c))
    assert 1 <= a < n, "Neispravni a"
    assert 1 <= b < n, "Neispravni b"
    assert 1 <= c < n, "Neispravni c"

    imena = []
    for i in range(n):
        ime = lines[i+2].strip()
        imena.append(ime)
        nl.append('{}\n'.format(ime))
        assert 3 <= len(ime) <= 20, "predugacko ime"
        for cc in ime: assert cc in 'qwertzuioplkjhgfdsamnbvcxy', "nedozvoljeno slovo"

    simena = set(imena)
    assert len(simena) == len(imena), "Postoji duplikat ime"
    izbaceno = []

    k = int(lines[n+2])
    nl.append('{}\n'.format(k))
    assert 1 <= k <= 10**5, "Neispravan k"
    poslano = 0
    for i in range(k):
        zahtjev = lines[n+3+i].strip()
        tip = zahtjev.split()[0]
        assert tip == 'SALJI' or tip == 'IZBACI'
        if tip == 'SALJI':
            poslano = 1
            od, do = zahtjev.split()[1:]
            assert od != do, "Mora bit razliciti igrac"
            assert od[0] not in izbaceno
            assert do[0] not in izbaceno
            assert od in simena
            assert do in simena
            nl.append('{} {} {}\n'.format(tip, od, do))
        if tip == 'IZBACI':
            slovo = zahtjev.split()[1]
            nl.append('{} {}\n'.format(tip, slovo))
            assert slovo in 'qwertzuioplkjhgfdsamnbvcxy', "nedozvoljeno slovo"
            izbaceno.append(slovo)

    assert poslano == 1, "barem jedan zahtjev mora bit salji"
    assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
    assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
    return n, k, a, b, c


# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'jedan':1, 'jedan_mali': 1, 'b=c_mali': 1, 'jednako': 2, 'jednako_mali': 1, 'b=c': 3, 'mali': 2, 'normalni': 4}

def what_cluster(data):
    n, k, a, b, c = data
    if a == b and b == c and a == 1: 
        if n <= 5000 and k <= 5000: return "jedan_mali"
        return 'jedan'
    if a == b and b == c: 
        if n <= 5000 and k <= 5000: return "jednako_mali"
        return 'jednako'
    if b == c: 
        if n <= 5000 and k <= 5000: return "b=c_mali"
        return 'b=c'
    if n <= 5000 and k <= 5000: return 'mali'
    return 'normalni'


################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
    # mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

    files.sort()
    B = []
    for f in files:
        if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
            B[-1].append(f)
        else:
            B.append([f])
    return B


if __name__ == "__main__":
    f = []
    for pattern in sys.argv[1:]:
        for filename in glob.glob(pattern):
            f.append(filename)

    bc = []
    for batch in group_in_batches(f):
        if 'dummy' not in batch[0]:
            bc.append([])
        for filename in batch:
            print("{}: ".format(filename), end="")
            try:
                lines = open(filename).readlines()
                summary = check(lines)
                c = what_cluster(summary)
                if 'dummy' not in batch[0]:
                    bc[-1].append(c)
            except Exception as e:
                print("Greska!", e)
                raise
            else:
                print("Sve ok! (cluster {}, summary = {})".format(c, summary))

    clusters = {}
    for b in bc:
        for c in b:
            assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
        if not b[0] in clusters:
            clusters[b[0]] = 0
        clusters[b[0]] += 1

    assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

    # Buda test - provjeri duplikate
    hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
    assert len(hashes) == len(f), "Ima duplikata!"
